--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- Class used in the picking intersection system within the game engine. Using a ray, the engine performs picking operations on a scene graph or any subtree. Given a ray and a subtree, the subtree is traversed and matching nodes are added to an array.
--- @class niPick
--- @field coordinateType ni.pickCoordinateType The coordinate type for the object. Maps to values in [`ni.pickCoordinateType`](https://mwse.github.io/MWSE/references/ni/pick-coordinate-types/) table.
--- @field frontOnly boolean If true, back face triangles (those with clockwise winding order) are culled prior to intersection calculations. If false, intersections of ray with triangles are computed regardless of triangle orientation.
--- 	
--- @field intersectType ni.pickIntersectType The intersect type for the object. Maps to values in [`ni.pickIntersectType`](https://mwse.github.io/MWSE/references/ni/pick-intersection-types/) table.
--- @field lastAddedRecord niPickRecord The pick record that was last added to the object.
--- @field observeAppCullFlag boolean If true, the pick stops if it encounters an object with the 'app culled' flag set.  If false, the pick will continue over 'app culled' objects.
--- 	
--- @field pickType ni.pickType The pick type for the object. Maps to values in [`ni.pickType`](https://mwse.github.io/MWSE/references/ni/pick-types/) table.
--- @field results niPickRecord[] *Read-only*. The array of pick records obtained by the last call to `pickObjects`.
--- @field returnColor boolean If true, a vertex color value is returned for the point of intersection of triangles during picking.
--- @field returnNormal boolean If true, a unit-length normal is returned for the point of intersection of triangles intersected during the picking.
--- @field returnSmoothNormal boolean If true and if vertex normals exist, then a unit-length normal vector is interpolated from the vertex normals and returned during the picking operation.
--- @field returnTexture boolean If true, texture coordinates are returned for the point of intersection of triangles during the picking operation.
--- @field root niBSAnimationNode|niBSParticleNode|niBillboardNode|niCollisionSwitch|niNode|niSortAdjustNode|niSwitchNode The root of the scene graph on which the next picking operation will be performed.
--- @field sortType ni.pickSortType The sort type for the object. Maps to values in [`ni.pickSortType`](https://mwse.github.io/MWSE/references/ni/pick-sort-types/) table.
niPick = {}

--- Clears the results of any previous picking operation.
function niPick:clearResults() end

--- Performs the picking operation by casting a ray.
--- @param origin tes3vector3 The origin of the ray in world coordinates.
--- @param direction tes3vector3 No description yet available.
--- @param append? boolean *Default*: `false`. This parameter indicates whether the new results are appended to the results array, or if a new array is formed clearing the results array.
--- @param maxDistance? number *Optional*. Default value: 0.0F
function niPick:pickObjects(origin, direction, append, maxDistance) end

